/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tristankechlo.livingthings.client.model.AdvancedEntityModel;
import com.tristankechlo.livingthings.entity.FlamingoEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class FlamingoModel<T extends FlamingoEntity>
extends AdvancedEntityModel<T> {
    private final ModelPart Body;
    private final ModelPart Head;
    private final ModelPart LeftLegTop;
    private final ModelPart LeftLegBottom;
    private final ModelPart LeftFoot;
    private final ModelPart RightLegTop;
    private final ModelPart RightLegBottom;
    private final ModelPart RightFoot;

    public FlamingoModel(ModelPart root) {
        this.Body = root.m_171324_("Body");
        ModelPart neckBottom = this.Body.m_171324_("NeckBottom");
        ModelPart neck2 = neckBottom.m_171324_("Neck2");
        ModelPart neck3 = neck2.m_171324_("Neck3");
        ModelPart neck4 = neck3.m_171324_("Neck4");
        ModelPart neck5 = neck4.m_171324_("Neck5");
        ModelPart neckTop = neck5.m_171324_("NeckTop");
        this.Head = neckTop.m_171324_("Head");
        ModelPart legs = this.Body.m_171324_("Legs");
        this.LeftLegTop = legs.m_171324_("LeftLegTop");
        this.LeftLegBottom = this.LeftLegTop.m_171324_("LeftLegBottom");
        this.LeftFoot = this.LeftLegBottom.m_171324_("LeftFoot");
        this.RightLegTop = legs.m_171324_("RightLegTop");
        this.RightLegBottom = this.RightLegTop.m_171324_("RightLegBottom");
        this.RightFoot = this.RightLegBottom.m_171324_("RightFoot");
    }

    public void setupAnim(FlamingoEntity flamingo, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.f_104203_ = 0.2617994f + headPitch * ((float)Math.PI / 180);
        this.Head.f_104204_ = netHeadYaw / 3.75f * ((float)Math.PI / 180);
        if (flamingo.isLeftLegUp()) {
            this.LeftLegTop.f_104203_ = 1.3089969f;
            this.LeftLegBottom.f_104203_ = -2.7052603f;
            this.LeftFoot.f_104203_ = 0.17453292f;
            this.RightLegTop.f_104203_ = 0.1308997f;
            this.RightLegBottom.f_104203_ = -0.17453292f;
            this.RightFoot.f_104203_ = 0.04363323f;
        } else if (flamingo.isRightLegUp()) {
            this.LeftLegTop.f_104203_ = 0.1308997f;
            this.LeftLegBottom.f_104203_ = -0.17453292f;
            this.LeftFoot.f_104203_ = 0.04363323f;
            this.RightLegTop.f_104203_ = 1.3089969f;
            this.RightLegBottom.f_104203_ = -2.7052603f;
            this.RightFoot.f_104203_ = 0.17453292f;
        } else {
            this.LeftLegTop.f_104203_ = 0.1308997f + Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
            this.LeftLegBottom.f_104203_ = -0.17453292f;
            this.LeftFoot.f_104203_ = 0.04363323f;
            this.RightLegTop.f_104203_ = 0.1308997f + Mth.m_14089_((float)(limbSwing * 0.6662f)) * limbSwingAmount;
            this.RightLegBottom.f_104203_ = -0.17453292f;
            this.RightFoot.f_104203_ = 0.04363323f;
        }
    }

    public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            matrixStackIn.m_85841_(0.5f, 0.5f, 0.5f);
            matrixStackIn.m_85837_(0.0, 1.5, 0.0);
        }
        this.Body.m_104301_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(36, 49).m_171488_(-3.0f, -15.9f, -4.0f, 6.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)20.9f, (float)0.0f));
        PartDefinition Back1 = Body.m_171599_("Back1", CubeListBuilder.m_171558_().m_171514_(52, 25).m_171488_(-2.5f, -0.4808f, -0.8778f, 5.0f, 4.0f, 1.0f, new CubeDeformation(-0.01f)), PartPose.m_171423_((float)0.0f, (float)-12.55f, (float)7.475f, (float)-0.1833f, (float)0.0f, (float)0.0f));
        PartDefinition Back2 = Body.m_171599_("Back2", CubeListBuilder.m_171558_().m_171514_(48, 31).m_171488_(-2.5f, 1.925f, -0.375f, 5.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-15.05f, (float)3.85f));
        PartDefinition Back3 = Body.m_171599_("Back3", CubeListBuilder.m_171558_().m_171514_(44, 39).m_171488_(-2.5f, -0.3463f, -0.5502f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)0.0f, (float)-15.3f, (float)3.8f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition Legs = Body.m_171599_("Legs", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-9.9f, (float)0.0f));
        PartDefinition LeftLegTop = Legs.m_171599_("LeftLegTop", CubeListBuilder.m_171558_().m_171514_(0, 56).m_171488_(-0.5f, -1.0f, -0.5f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)1.0f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition LeftLegBottom = LeftLegTop.m_171599_("LeftLegBottom", CubeListBuilder.m_171558_().m_171514_(5, 57).m_171488_(-1.0f, 0.0f, -0.5f, 1.0f, 6.0f, 1.0f, new CubeDeformation(-0.001f)), PartPose.m_171423_((float)0.5f, (float)6.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition LeftFoot = LeftLegBottom.m_171599_("LeftFoot", CubeListBuilder.m_171558_().m_171514_(10, 61).m_171488_(-1.5f, -1.0f, -2.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)6.0f, (float)0.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition RightLegTop = Legs.m_171599_("RightLegTop", CubeListBuilder.m_171558_().m_171514_(0, 46).m_171488_(-0.5f, -1.0f, -0.5f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)1.0f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition RightLegBottom = RightLegTop.m_171599_("RightLegBottom", CubeListBuilder.m_171558_().m_171514_(5, 47).m_171488_(-1.0f, 0.0f, -0.5f, 1.0f, 6.0f, 1.0f, new CubeDeformation(-0.001f)), PartPose.m_171423_((float)0.5f, (float)6.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition RightFoot = RightLegBottom.m_171599_("RightFoot", CubeListBuilder.m_171558_().m_171514_(10, 51).m_171488_(-1.5f, -1.0f, -2.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)6.0f, (float)0.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition NeckBottom = Body.m_171599_("NeckBottom", CubeListBuilder.m_171558_().m_171514_(0, 35).m_171488_(-2.5f, -3.0f, -1.0f, 5.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-11.9f, (float)-4.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition Neck2 = NeckBottom.m_171599_("Neck2", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171488_(-2.0f, -2.5f, -1.0f, 4.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-1.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition Neck3 = Neck2.m_171599_("Neck3", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171488_(-1.5f, -2.0f, -1.0f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-1.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition Neck4 = Neck3.m_171599_("Neck4", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171488_(-1.0f, -1.5f, -2.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.01f)), PartPose.m_171423_((float)0.0f, (float)-0.1109f, (float)-1.2724f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition Neck5 = Neck4.m_171599_("Neck5", CubeListBuilder.m_171558_().m_171514_(0, 10).m_171488_(-1.0f, -0.825f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.001f)), PartPose.m_171423_((float)0.0f, (float)-0.5921f, (float)-2.4868f, (float)1.3963f, (float)0.0f, (float)0.0f));
        PartDefinition NeckTop = Neck5.m_171599_("NeckTop", CubeListBuilder.m_171558_().m_171514_(0, 3).m_171488_(-1.0f, -2.5f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.95f, (float)-0.05f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition Head = NeckTop.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(21, 28).m_171488_(-1.5f, -3.0f, -4.0f, 3.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.126f, (float)0.1477f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition Beak = Head.m_171599_("Beak", CubeListBuilder.m_171558_().m_171514_(23, 19).m_171488_(-1.0f, -0.5152f, -3.1737f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)0.0f, (float)-1.5619f, (float)-2.4006f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition Beak2 = Beak.m_171599_("Beak2", CubeListBuilder.m_171558_().m_171514_(35, 21).m_171488_(-1.0f, -0.5f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.1884f, (float)-3.2262f, (float)-0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition Beak3 = Beak.m_171599_("Beak3", CubeListBuilder.m_171558_().m_171514_(34, 25).m_171488_(-1.0f, -0.5f, -0.5f, 2.0f, 1.0f, 2.0f, new CubeDeformation(-0.01f)), PartPose.m_171423_((float)0.0f, (float)1.1255f, (float)-3.6706f, (float)0.2662f, (float)0.0f, (float)0.0f));
        PartDefinition Wings = Body.m_171599_("Wings", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)3.1f, (float)0.0f));
        PartDefinition LeftWing = Wings.m_171599_("LeftWing", CubeListBuilder.m_171558_().m_171514_(48, 0).m_171488_(0.0f, -2.5f, 0.0f, 1.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-15.5f, (float)-3.0f, (float)-0.1745f, (float)0.0873f, (float)0.0f));
        PartDefinition RightWing = Wings.m_171599_("RightWing", CubeListBuilder.m_171558_().m_171514_(31, 0).m_171488_(-1.0f, -2.5f, 0.0f, 1.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)-15.5f, (float)-3.0f, (float)-0.1745f, (float)-0.0873f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }
}

